##FINAL JOGSS GRAPHIC

library(ggplot2)
commpos <- read.csv("Articles.csv", sep=",")
epos <- read.csv("Citations.csv", sep=",")

commpos <- subset(commpos, commpos$clust_name!='Other')
#fix a strange rounding error where the nodes and edges don't quite align
commpos$xsmall <- round(as.numeric(as.character(commpos$xsmall)), 5)
commpos$ysmall <- round(as.numeric(as.character(commpos$ysmall)), 5)
epos$sx <- round(epos$sx, 5)
epos$sy <- round(epos$sy, 5)

#join each edge to a source node
#this allows us to colour the edges
epos <- merge(epos, commpos, by.x=c("sx","sy"), by.y=c("xsmall","ysmall"))


#make the final graphic

cols <- c("#E69F00", "#56B4E9", "#009E73", "#CC79A7", "#0072B2")
ggplot() + geom_segment(data=epos, aes(x=sx, y=sy, xend=tx, yend=ty, color=clust_name), alpha=0.2) + geom_point(data=commpos, aes(x=as.numeric(as.character(xsmall)),y=as.numeric(as.character(ysmall)),color=clust_name, fill=clust_name, shape=clust_name), size=3, alpha=0.5) + xlab("") + ylab("") + theme_bw() + theme(line = element_blank(), axis.text=element_blank(), axis.title=element_blank(), legend.text=element_text(size=18)) + scale_shape_manual("", values=c(21,22,23,24,25)) + scale_fill_manual("", values=cols) + scale_color_manual("", values=cols) 
ggsave(w=12,h=8,"JOGSS Graphic.png")


#graphic with numeric cluster ids on each node
ggplot() + geom_segment(data=epos, aes(x=sx, y=sy, xend=tx, yend=ty, color=clust_name), alpha=0.2) + geom_point(data=commpos, aes(x=as.numeric(as.character(xsmall)),y=as.numeric(as.character(ysmall)),color=clust_name, fill=clust_name, shape=clust_name), size=3, alpha=0.5) + xlab("") + ylab("") + theme_bw() + theme(line = element_blank(), axis.text=element_blank(), axis.title=element_blank(), legend.text=element_text(size=18)) + scale_shape_manual("", values=c(21,22,23,24,25)) + scale_fill_manual("", values=cols) + scale_color_manual("", values=cols) + geom_text(data=commpos, aes(x=as.numeric(as.character(xsmall)),y=as.numeric(as.character(ysmall)), label=cluster_id))

ggsave(w=12,h=8,"JOGSS Graphic - Cluster Detail.png")
